import matplotlib 
matplotlib.use('Agg')
import matplotlib.pyplot as plt
from matplotlib.colors import LinearSegmentedColormap
from matplotlib.patches import Ellipse
from matplotlib.patches import Circle
from matplotlib.pyplot import MultipleLocator

from astropy.io import fits
from astropy.wcs import wcs
from astropy import units as u
from astropy.visualization.wcsaxes import SphericalCircle
from astropy.convolution import Gaussian2DKernel
from astropy.convolution import convolve_fft

import scipy.ndimage as ndimage
import numpy as np
import math


#Color Map
mycolor = ['black','blue','royalblue','cyan','yellow','orange','red','white']
cmap_def = LinearSegmentedColormap.from_list('my_list',mycolor)

#cmap_def.set_under('blue')
#cmap_def.set_over('red')

#.with_extremes(over='red', under='blue'))

fig = plt.figure(figsize=(10, 6))
FileName = "100TeV-20240426.fits" 
hdu_KM2A = fits.open(FileName)
wcsobj_KM2A = wcs.WCS(FileName)

ax = fig.add_subplot(1,1,1, projection=wcsobj_KM2A)
#im = ax.imshow(hdu_KM2A[0].data, cmap=cmap_def,aspect=1)
#im = ax.imshow(hdu_KM2A[0].data, cmap='hot',aspect=1,vmin=3)
cont = ax.contour(hdu_KM2A[0].data, [9,25,49],
                   colors=["black","black","black"],linestyles=['--','--','--'],alpha=1,linewidths=[2.0,2.0,2.0]) #contour lines
#plt.clabel(cont, inline=True, fontsize=10) #add the height number
#cbar = plt.colorbar(im, pad=0.05,fraction=0.024)

#plt.xticks(np.arange(0,8,1),np.arange(29,36,1))
#plt.yticks(np.arange(0,8,1),np.arange(41,45,1))
plt.setp(ax.get_xticklabels(),fontsize=20)
ax.set_xlim(np.shape(hdu_KM2A[0].data)[1]-160.5,np.shape(hdu_KM2A[0].data)[1]-0.5)
ax.set_ylim(np.shape(hdu_KM2A[0].data)[0]-80.5,np.shape(hdu_KM2A[0].data)[0]-0.5)
ax.coords[0].set_major_formatter('d')
ax.coords[1].set_major_formatter('d')

## not able to adjust the ticks range
#plt.xticks(np.arange(29,36,0.2),transform=ax.get_transform('world'))
#plt.yticks(np.arange(40,45,0.2),transform=ax.get_transform('world'))

xminor=MultipleLocator(0.2)
ax.xaxis.set_minor_locator(xminor)

plt.tick_params(labelsize=16)

labels=ax.get_xticklabels()+ax.get_yticklabels()
[label.set_fontname('Verdana') for label in labels]


ax_ra = ax.coords[0]
ax_dec = ax.coords[1]
ax_ra.set_ticks_position('b')
ax_ra.set_ticklabel_position('b')
ax_dec.set_ticks_position('l')
ax_dec.set_ticklabel_position('l')
ax_ra.set_major_formatter('d')
ax_ra.set_axislabel_position('b')
ax_dec.set_axislabel_position('l')
ax_ra.set_axislabel('R.A.',fontsize=16)
ax_dec.set_axislabel('Decl.',fontsize=16)
#ax.coords.grid(True, color='white', ls='solid') #set grid
plt.show

#Plot the Point******  
#Point_x = [29.99,31.78,32.95,34.08]
#Point_y = [43.56,43.00,42.93,42.64]
#Point_name = ['J0158+4356','J0206+4300','J0211+4292','J0216+4264',"PSR J0218+4232"]

Point_x = [31.76,34.10]
Point_y = [43.02,42.66]
#plt.scatter(Point_x,Point_y,marker = '+', color = 'c',transform=ax.get_transform('world'))
#ax.text(30.,43.2,'J0158+4356',fontsize=8,color='white',weight='bold',transform=ax.get_transform('world'))
#ax.text(32.05,42.65,'J0206+4300',fontsize=8,color='white',weight='bold',transform=ax.get_transform('world'))
#ax.text(33.5,43.1,'J0211+4292',fontsize=8,color='white',weight='bold',transform=ax.get_transform('world'))
#ax.text(34.45,43.15,'J0216+4239',fontsize=8,color='white', weight='bold',transform=ax.get_transform('world'))
#ax.text(35.2,42.15,'MSP J0218+4232',fontsize=8,color='white',weight='bold',transform=ax.get_transform('world'))

'''
#draw a rectangle
line1x=[29.5,34.8,34.8,29.5,29.5]
line1y=[43.3,42.2,42.8,43.9,43.3]
ax.plot(line1x,line1y,linewidth=2,color='white',transform=ax.get_transform('world'))
#ax.add_patch(rect)
'''
#plot MSP
MSP_x=[34.53]
MSP_y=[42.54]
ax.plot(MSP_x,MSP_y,marker = '*',markersize=15, color = 'cyan',transform=ax.get_transform('world'))

#ax.text(34.73,42.30,'MSP',fontsize=10,color='cyan',transform=ax.get_transform('world'))


#plot event
E=[423,459,505,395,428,390,493,764,428,622,505,437,726,524]

ra=[31.65,30.71,34.19,33.01,32.88,33.63,33.73,32.29,31.66,34.05,28.63,32.73,33.57,31.82]

dec=[43.44,43.54,42.54,42.94,43.12,42.74,42.62,43.39,43.33,42.72,43.55,42.5,42.79,42.56]

#sizes = [2 * e for e in E]

sizes=[0.14,0.16,0.13,0.17,0.14,0.14,0.15,0.12,0.17,0.12,0.14,0.13,0.14,0.14,0.13,0.15]
## 自定义颜色映射（可选）

#colors = ['blue', 'green', 'yellow', 'red']
colors=['royalblue', 'gray', 'darkorchid', 'darkorange']
cmap = LinearSegmentedColormap.from_list('custom_cmap', colors, N=256)
# 绘制散点图
scatter = plt.scatter(ra, dec, 
                     c=E, 
                     cmap='coolwarm',  # 可以尝试：'viridis', 'plasma', 'inferno', 'magma', 'coolwarm'
                     s=500,          # 圆圈大小
                     alpha=0.8,      # 透明度
                     edgecolors='gray', 
                     linewidth=1,transform=ax.get_transform('world'))

# 添加颜色条
cbar = plt.colorbar(scatter, shrink=1.0)
cbar.set_label('Energy (E)', fontsize=14, fontweight='bold')


#to show the first two hided events
E=[387,390]
ra=[34.04,33.63]
dec=[42.71,42.74]
sizes = [2 * e for e in E]
#plt.scatter(ra,dec,s=sizes,alpha=1.0,marker='o',edgecolor='orange',linewidths=1,color='mediumpurple',label='>400TeV',transform=ax.get_transform('world'))



ax.text(32.95,43.75,'760$^{+60}_{-40}$TeV',fontsize=20,color='brown',weight='bold',transform=ax.get_transform('world'))

plt.savefig('Eventabove400TeV.jpg', facecolor='white', edgecolor='white')
